#ifndef __PROCESSES_H__
#define __PROCESSES_H__

#include "pdf_functions.h"

/*
 * Implementazioni della classe generica Xsection
 */

/*
 * class DrellYan_Xsection
 ************************* 
 * Sezione d'urto per il processo qqbar -> gamma* -> l+l-
 */
class DrellYan_Xsection : public Xsection {
public:
  static double xsec(double *x, double *p);
  /*
   * Costruttore: 
   *  - un nome, richiesto dalla TF1 ausiliaria
   *  - carica del quark
   *  - energia nel centro di massa (default=1 GeV) 
   */
  DrellYan_Xsection(const char* name, double Qf=1., double s=1.);
  void SetQf(double Qf); 
  ClassDef(DrellYan_Xsection,1);
};

/*
 * class W_Xsection
 ************************* 
 * Sezione d'urto per il processo u dbar -> W+ -> l+ nu
 * ed il suo coniugato di carica.
 */
class W_Xsection : public Xsection {
public:
  static double xsec(double *x, double *p);
  /*
   * Costruttore: 
   *  - un nome, richiesto dalla TF1 ausiliaria
   *  - direzione del quark u o ubar (segno del pz)
   *  - energia nel centro di massa (default=1 GeV) 
   */
  W_Xsection(const char* name, int qdir, double s=1.);
  ClassDef(W_Xsection,1);
};


#endif
