#include "processes.h"

#include <cmath>
#include "TMath.h"

// ===================================================================
// Set predefinito di costanti
#include "constants.C"

// ====== CLASS DrellYan ======== 

double DrellYan_Xsection::xsec(double *x, double *p) {
    // Sezione d'urto del processo di Drell-Yan.
    // Parametri: 
    // - p[0] = s, 
    // - p[1] = carica del quark, 
  return (1./3.)*hc2*pow(0.5*alpha*p[1],2)*(1+x[0]*x[0])/p[0];
}

DrellYan_Xsection::DrellYan_Xsection(const char* name, double Qf, double s) :
  Xsection(name,&xsec,2,s) {
  SetQf(Qf);
}

void DrellYan_Xsection::SetQf(double Qf) { SetParameter(1,Qf); } 

// ====== CLASS W ======== 

double W_Xsection::xsec(double *x, double *p) {
  // Sezione d'urto per processo W->l nu 
  // Parametri: 
  // - p[0] = s, 
  // - p[1] = m_W, 
  // - p[2] = Gamma_W
  // - p[3] = direzione del quark u o ubar (segno del p_z)
  //          x[0] è il cos(theta) del letprone carico prodotto
  double k=(1./3.)*sqrt(2)*TMath::Pi()*GF*Vud2*p[1]*p[1]; // sezione d'urto totale
  double BW=((p[1]*p[2])/TMath::Pi())/(pow(p[0]-p[1]*p[1],2)+pow(p[1]*p[2],2)); // Breit-Wigner normalizzata a 1
  double ang=(1./TMath::TwoPi())*(3./8.)*(1.-p[3]*x[0]+x[0]*x[0]); // distribuzione angolare normalizzata a 1
  return k*BW*ang*(1./9.); // Branching Rratio W->l nu ~ 1/9
} 

W_Xsection::W_Xsection(const char* name, int qdir, double s) :  
  Xsection(name,&xsec,4,s) {
  SetParameter(1,MW);
  SetParameter(2,GW);
  if ( qdir>0 ) SetParameter(3,1.);
  else if ( qdir<0 ) SetParameter(3,-1.);
  else SetParameter(3,0.);
}

