#include "TF1.h"

const double xMin=1.E-7;
const double xMax=1.;
 
TF1 xu_v("xu_v","1.78*x^0.5*(1-x^1.51)^3.5",xMin,xMax);
TF1 xd_v("xd_v","0.67*x^0.4*(1-x^1.51)^4.5",xMin,xMax);
TF1 xu_s("xu_s","0.182*(1-x)^8.54"         ,xMin,xMax);
TF1 xs_s("xs_s","0.081*(1-x)^8.54"         ,xMin,xMax);
TF1 xsea("xsea","4.*xu_s+2.*xs_s"          ,xMin,xMax);
TF1 xG  ("xG"  ,"(2.62+9.17*x)*(1-x)^5.90" ,xMin,xMax);

TF1 u_v ("u_v" ,"xu_v/x"                   ,xMin,xMax);
TF1 d_v ("d_v" ,"xd_v/x"                   ,xMin,xMax);
TF1 u_s ("u_s" ,"xu_s/x"                   ,xMin,xMax);
TF1 u_t ("u_t" ,"u_v+u_s"                  ,xMin,xMax);
TF1 d_t ("d_t" ,"d_v+u_s"                  ,xMin,xMax);
TF1 s_s ("s_s" ,"xs_s/x"                   ,xMin,xMax);
TF1 sea ("sea" ,"xsea/x"                   ,xMin,xMax);
TF1 G   ("G"   ,"xG/x"                     ,xMin,xMax);

TF1 TotalM("TotalM","xu_v+xd_v+xsea+xG",xMin,xMax);





