#include "pdf_functions.h"
#include "processes.h"
#include "pdf_set1.C"
#include "constants.C"

#include "TCanvas.h"
#include "TMath.h"

TCanvas* ShowHisto(const char * title, TH1* h, bool log=false) {
  TCanvas* c = new TCanvas(title,title,600,600);
  if ( log ) c->SetLogy();
  TH2F* h2 = dynamic_cast<TH2F*>(h);
  if ( h2 ) h2->Draw("colz");
  else h->Draw();
  return c;
}


/*
 * XsecPDFlist object per il calcolo della sezione d'urto di produzione del W
 * Nei grafici, la particella 1 è il leptone carico.
 * I parametri sono:
 * - sqrts: energia nel centro di massa
 * - pbar: vero per collisioni ppbar e falso per pp
 * - Wsign: carica del W, 0 è la somma inclusiva di W+ e W-
 */
XsecPDFlist* Wtheory(double sqrts,bool pbar,int Wsign) {
  W_Xsection *udxsec =  new W_Xsection("Wplus_up",+1);
  W_Xsection *duxsec =  new W_Xsection("Wplus_dn",-1);
  
  PDFlist *udbar = new PDFlist();
  PDFlist *dubar = new PDFlist();
  if (pbar) {
    if ( Wsign >= 0 ) {
      udbar->AddPartonType(&u_t,&d_t);
      dubar->AddPartonType(&u_s,&u_s);
    } 
    if ( Wsign <= 0 ) {
      dubar->AddPartonType(&d_t,&u_t);
      udbar->AddPartonType(&u_s,&u_s);
    } 
  } else {
    if ( Wsign >= 0 ) {
      udbar->AddPartonType(&u_t,&u_s);
      dubar->AddPartonType(&u_s,&u_t);
    }
    if ( Wsign <= 0 ) {
      dubar->AddPartonType(&d_t,&u_s);
      udbar->AddPartonType(&u_s,&d_t);
    }
  }
  XsecPDFlist* W = new XsecPDFlist(udbar,udxsec);
  W->AddProcess(dubar,duxsec);
  W->SetSRange(10.,210.);
  W->ConfigureHisto(10.,210.,5.);
  W->Simulate(sqrts);
  ShowHisto("y",W->GetHisto(XsecPDFlist::RAPIDITY));
  ShowHisto("s",W->GetHisto(XsecPDFlist::SQRTSHAT),true);
  ShowHisto("sy",W->GetHisto(XsecPDFlist::YVSHAT));
  ShowHisto("y1",W->GetHisto(XsecPDFlist::Y1));
  ShowHisto("deltaEta",W->GetHisto(XsecPDFlist::DELTAY));
  ShowHisto("pT",W->GetHisto(XsecPDFlist::PT1));
  ShowHisto("mT",W->GetHisto(XsecPDFlist::MT));
  ShowHisto("pTvsy",W->GetHisto(XsecPDFlist::PTVSY1));
  W->PrintXsec();
  return W;
}

Experiment* Wexperiment(double sqrts,bool pbar,int Wsign) {
  W_Xsection *udxsec =  new W_Xsection("Wplus_up",+1);
  W_Xsection *duxsec =  new W_Xsection("Wplus_dn",-1);
  
  PDFlist *udbar = new PDFlist();
  PDFlist *dubar = new PDFlist();
  if (pbar) {
    if ( Wsign >= 0 ) {
      udbar->AddPartonType(&u_t,&d_t);
      dubar->AddPartonType(&u_s,&u_s);
    } 
    if ( Wsign <= 0 ) {
      dubar->AddPartonType(&d_t,&u_t);
      udbar->AddPartonType(&u_s,&u_s);
    } 
  } else {
    if ( Wsign >= 0 ) {
      udbar->AddPartonType(&u_t,&u_s);
      dubar->AddPartonType(&u_s,&u_t);
    }
    if ( Wsign <= 0 ) {
      dubar->AddPartonType(&d_t,&u_s);
      udbar->AddPartonType(&u_s,&d_t);
    }
  }
  Experiment* W = new Experiment(udbar,udxsec);
  W->AddProcess(dubar,duxsec);
  W->SetSRange(10.,210.);
  W->SetResolution(0.02,true,6,false);
  W->SetIntegratedLumi(0.320);
  W->ConfigureHisto(10.,210.,5.);
  W->Simulate(sqrts);
  ShowHisto("pTe",W->GetHisto(XsecPDFlist::PT1));
  ShowHisto("pTnu",W->GetHisto(XsecPDFlist::PT2));
  ShowHisto("mT",W->GetHisto(XsecPDFlist::MT));
  W->PrintXsec();
  return W;
}

